/**
 * Simple data plotter
 */

var cfgPane_autoCurPlot = true;
var logXOn = false;
var logYOn = false;
var dbOn = false;

// toggle logscale property of plot and save state
function doLogX(btn)
{
    checkLogOK();
    if (!logXCapable) {
        alert("The x-axis data cannot be plotted on a log scale");
        return;
    }

    // check all plots
    logXOn = !logXOn;
    for (dg1Ind = 0; dg1Ind < dg1.length; dg1Ind++) {
        dg1[dg1Ind].updateOptions({axes: {x: {logscale: logXOn}}});
    }
    btn.value = "LogX " + (!logXOn ? "ON" : "OFF");
}

// toggle logscale property of plot and save state
function doLogY(btn)
{
    var err = false;
    checkLogOK();

    if (!logYOn && !logYCapable) { // only check if it is not on
        alert("The y-axis data cannot be plotted on a log scale, use 'Select Signals' to filter" + (dbOn ? ", and try turning off dB" : ""));
        return;
    }

    // check all plots and update
    logYOn = !logYOn;
    for (dg1Ind = 0; dg1Ind < dg1.length; dg1Ind++) {
        dg1[dg1Ind].updateOptions({logscale: logYOn});
    }
    btn.value = "LogY " + (!logYOn ? "ON" : "OFF");
}

function makeImage() {
    var newImgComp1 = $('#plot1img')[0];
    Dygraph.Export.asPNG(dg1[0], newImgComp1, options);
    newImgComp1.setAttribute("width", 500);
    newImgComp1.setAttribute("height", p1i_h * 500 / p1i_w); // 620x460, 620/500=460/h\
    //window.location.href = newImgComp1.src.replace('image/png','image/octet-stream');
    $("#plotDiv").hide();
    $("#imgDiv").show();
}

function refreshPlot()
{
    document.location = document.location;
}

function log(s) {
    console.log(s);
}

// landscape (note ipad gives width as portrait width)
var theScreenWidth = parseInt(screen.height > screen.width ? screen.height : screen.width);
var theScreenHeight = parseInt(screen.height < screen.width ? screen.height : screen.width);

var simResult = "";
function postDataLoad()
{
    simResult = simResult.trim(); // new, needed because keep-alive feature on server sends spaces
    savSimRes = simResult;

    // seperate output and data
    var output = simResult.substring(simResult.indexOf("FL=") + 3, simResult.length);
    //localStorage.setItem("LASTSIMRESNICE", output);

    var isOP = false;

    // op analysis will go after FL
    if (output.indexOf("{NV:") != -1) {
        var ind1 = output.indexOf("{NV:");
        var ind2 = output.indexOf("}", ind1);
        if (ind1 != -1 && ind2 != -1) {
            var opRes = output.substring(ind1, ind2 + 1).trim();
            //localStorage.setItem("ANALYSIS_OP_NV", opRes);
            opRes = null;
            isOP = true;
        }
        ind1 = ind2 = null;
    }
    if (output.indexOf("{BC:") != -1) {
        var ind1 = output.indexOf("{BC:");
        var ind2 = output.indexOf("}", ind1);
        if (ind1 != -1 && ind2 != -1) {
            var opRes = output.substring(ind1, ind2 + 1).trim();
            //localStorage.setItem("ANALYSIS_OP_BC", opRes);
            opRes = null;
            isOP = true;
        }
        ind1 = ind2 = null;
    }

    // check for errors
    if (simResult.toLowerCase().indexOf("aborted") != -1 ||
        simResult.toLowerCase().indexOf("error in simulation") != -1 ||
        simResult.toLowerCase().indexOf("fatal error") != -1) {
        alert("Simulation was aborted, please check simuation results and/or netlist for errors");
    }
    else if (isOP) {
        opValuesOn = false;
        showOpValues(); // toggle
    }
    else {
        // plot, then go to sim tab
        plot();

        // turn on log x and db if ac analysis
        if(isACAnalysis) {
            doLogX($("#logXBtn")[0]);
            doDB($("#dbBtn")[0]);
        }

        if (lastNumSignals > 10) {
            alert("There are more than 10 signals plotted.  For best performance, consider  " +
                "removing some probes/ports and/or setting less signals to be plotted  " +
                "from the Plot Options menu.  ");
        }

        plottedYet = null;
    }

    isOP = null;
    output = null;
}

function finalReformat()
{
    $("#topDiv").css("height", "90%");
    $("#topDiv").css("width", "99%");
    $("#plotleg").css("padding-left", "10px");
    $("#plotleg").css("border-left-color", "grey");
    $("#plotleg").css("border-left-style", "solid");
    $("#plotleg").css("border-left-width", "2px");
    $("#plotleg").css("height", "99%");
    $("#plotOptionsDiv").css("padding-left", "10px");
    $("#plotOptionsDiv").css("border-left-color", "grey");
    $("#plotOptionsDiv").css("border-left-style", "solid");
    $("#plotOptionsDiv").css("border-left-width", "2px");
    $("#plotOptionsDiv").css("height", "99%");
}

$(document).ready(function() {

    simResult = "FL="; // sim result from spice

    try {
        setTimeout(function(){
            $.getJSON("simdata/simdata.json", function (data) {
                $.each(data, function (key, val) {
                    simResult = key + "=" + val + "\n" + simResult;
                });

                $("#plotWrapper").css("display", "none");
                $("#plotButtons").css("display", "none");
                $("#loadingImg").css("display", "block");
                postDataLoad();
                finalReformat();
                $("#loadingImg").css("display", "none");
                $("#plotButtons").css("display", "block");
                $("#plotWrapper").css("display", "block");
            });
        }, 1000); // give it a second will ya?
    } catch(e) {
        simResult = "";
    }
});

/***************************************************************
 * Function: plot
 * Params: n/a
 * DESC: plotting function, uses dygraph library
 * http://dygraphs.com/tests/two-axes.html
 ***************************************************************/
var xdata = [];
var xname = "";
var thedata = [];
var viData = [];
var dg1 = [];
var labelNames = [];
var labelsToRemove = [];  // all labels
var labelsToRemove2 = []; // array of true false values for each label
var logXOn = false;
var logYOn = false;
var logXCapable = true;
var logYCapable = true;
var options = null;
var isACAnalysis = false;
var savSimRes = ""; // last sim result
function plot() {
    // clear axes fields
    logXOn = false;
    $("#logXBtn").val("LogX ON");
    logYOn = false;
    $("#logYBtn").val("LogY ON");

    isACAnalysis = false;
    {
        $('#plotWrapper').show();

        if (dg1 != null && dg1.length > 0) {
            // check all plots
            for (dg1Ind = 0; dg1Ind < dg1.length; dg1Ind++) {
                dg1[dg1Ind].destroy();
            }
            dg1 = [];
        }

        labelsToRemove = [];  // all labels
        labelsToRemove2 = []; // array of true false values for each label

        xdata = [];
        xname = "";
        thedata = [];

        var res = savSimRes;

        if (res.indexOf("x-axis:") != -1) {
            res = res.substring(0, res.indexOf("FL="));
            res = res.split("\n")

            try {
                for (i = 0; i < res.length; i++) {
                    if (res[i] != "") {
                        var ind = res[i].indexOf("=");
                        var nm = res[i].substring(0, ind);
                        nm = nm.trim(); // very important when using " " on server for wait time

                        // remove current identifier
                        if (nm.indexOf("#br") != -1) {
                            nm = nm.substring(0, nm.indexOf("#br"));
                            if (nm.indexOf("I(") != 0) {
                                nm = "I(" + nm + ")";
                            }
                        }

                        var xaxis = 0
                        if (nm.indexOf("x-axis:") == 0) {
                            xname = nm.substring(nm.indexOf("x-axis:") + 7, nm.length);
                            xaxis = 1;

                            if(xname == "frequency") {
                                isACAnalysis = true;
                            }

                            xname = (xname == "time" ?
                                "Time (s)" :
                                (xname == "frequency" ?
                                    "Frequency (Hz)" :
                                    xname));
                        }

                        var dta = res[i].substring(ind + 1, res[i].length);
                        dta = dta.split(",");

                        //log("data: " + nm + " " + dta.length);

                        dataset = [];
                        for (j = 0; j < dta.length; j++) {
                            dta[j] = dta[j].trim();
                            if (dta[j] != null && dta[j] != "") {
                                if (xaxis == 1) {
                                    xdata.push(parseFloat(dta[j]));
                                    //log("xdata " + dta[j] + " " + parseFloat(dta[j]));
                                }
                                else {
                                    if (dbOn && nm.indexOf("vp(") == -1 && nm.indexOf("I(") == -1) {
                                        try {
                                            dataset.push(20.0 * Math.log10(parseFloat(dta[j])));
                                        } catch(logexp) {
                                            dataset.push(1e-12); // dummy so plot still works
                                        }
                                    } else {
                                        dataset.push(parseFloat(dta[j]));
                                    }
                                }
                            }
                        }

                        if (xaxis == 0) {
                            thedata.push([nm, dataset]);
                        }
                    }
                }

                log("xdata " + xdata.length);
                log("thedata " + thedata.length);

                // PLOT
                viData = [];

                labelNames = [xname];

                //var notPhaseNamesV = [];

                // to fix the phase discontinuity
                var lastPhase = {};
                var phaseMod = {};

                // which datapoint
                for (i = 0; i < xdata.length; i++) {
                    x = xdata[i];
                    viData.push([x]);

                    // which set
                    for (j = 0; j < thedata.length; j++) {
                        y = ((thedata[j])[1])[i];
                        ylabel = (thedata[j])[0];

                        if (ylabel.indexOf("I(") != -1) {
                            //iData[i].push(y);
                            viData[i].push(y);
                            if (i == 0) {
                                //labelNamesI.push(ylabel);
                                labelNames.push(ylabel);
                                labelsToRemove.push(ylabel);

                                if (cfgPane_autoCurPlot) {
                                    labelsToRemove2.push(true);
                                }
                                else {
                                    labelsToRemove2.push(false);
                                }
                            }
                        }
                        else {
                            {
                                if (ylabel.indexOf("vp(") == 0) {
                                    if (i == 0) // initialize
                                    {
                                        phaseMod[j] = 0.0;
                                        lastPhase[j] = y * 180.0 / 3.14159;
                                    }

                                    y = phaseMod[j] + y * 180.0 / 3.14159; // convert to degrees

                                    // going over discontinuity
                                    if ((lastPhase[j] < -135 && y > 135)) {
                                        phaseMod[j] -= 360.0;
                                        y += phaseMod[j];
                                    }
                                    else if ((lastPhase[j] > 135 && y < -135)) {
                                        phaseMod[j] += 360.0;
                                        y += phaseMod[j];
                                    }
                                    lastPhase[j] = y;
                                }

                                viData[i].push(y);
                            }

                            if (i == 0) {
                                labelNames.push(ylabel);
                                labelsToRemove.push(ylabel);
                                labelsToRemove2.push(true);
                            }
                        }
                    }
                }

                lastPhase = null;
                phaseMod = null;

                // for making secondary axis
                var seriesObj = {};

                // visibility array
                var vArr1 = [];
                for (va = 0; va < labelNames.length; va++) {
                    vArr1.push(true);
                    if (va > 0 && labelNames[va].indexOf("I(") == 0 ||
                        labelNames[va].indexOf("vp(") == 0) {
                        seriesObj[labelNames[va]] = {
                            axis: 'y2'
                        };
                    }
                    else if (va > 0 &&
                        (labelNames[va].indexOf("v(") == 0 ||
                            labelNames[va].indexOf("vdb(") == 0)) {
                        seriesObj[labelNames[va]] = {
                            axis: 'y'
                        };
                    }
                }

                var colorArr = colorScheme(labelNames.length);

                // combined options
                options = {
                    labels: labelNames,
                    height: "90%",
                    width: "90%",
                    title: " ", // gives a little space on top
                    titleHeight: 24,
                    xlabel: xname,
                    ylabel: (dbOn ? 'Voltage (dBV)' : 'Voltage (V)'),
                    y2label: 'Current (A)' + (isACAnalysis ? ' / Phase Angle (Degrees)' : ''),
                    series: seriesObj,
                    drawPoints: true,
                    pointSize: 1,
                    highlightCircleSize: 4,
                    labelsDiv: 'plotleg',
                    labelsSeparateLines: true,
                    showLabelsOnHighlight: true,
                    stackedGraph: false,
                    colorSaturation: 0.8,
                    visibility: vArr1,
                    hideOverlayOnMouseOut: false,
                    legend: "always",
                    //sigFigs: 10,
                    digitsAfterDecimal: 3,
                    strokeWidth: 2,
                    axisLabelWidth: 80,
                    drawAxesAtZero: true,
                    colors: colorArr,
                    legendFormatter: legendFormatter
                };
                colorArr = null;

                // save # signals and limit them in plot
                lastNumSignals = thedata.length;
                seriesObj = null;

                var plotW = $("#plot1")[0].width;
                var plotH = $("#plot1")[0].height;
                $("#plot1").css("width", plotW+"px");
                $("#plot1").css("height", plotH+"px");

                dg1.push(new Dygraph(document.getElementById("plot1"), viData, options));
                doPlotUpdateAdv();
                advancedPlotting();

                // format for csv
                var csvStr = "";
                for (var xInd = 0; xInd < labelNames.length; xInd++) {
                    if (xInd > 0) {
                        csvStr += ",";
                    }
                    csvStr += labelNames[xInd].replace(/,/g, "/");
                }
                csvStr += "\n";
                for (var xInd = 0; xInd < viData.length; xInd++) {
                    for (var xInd2 = 0; xInd2 < viData[xInd].length; xInd2++) {
                        if (xInd2 > 0) {
                            csvStr += ",";
                        }
                        csvStr += viData[xInd][xInd2];
                    }
                    csvStr += "\n";
                }
                //localStorage.setItem("LASTSIMRAW", csvStr);
                csvStr = null;

                //notPhaseNamesV = null;

                checkLogOK();

                $("canvas").on("contextmenu",function(){
                    return false;
                });

            }
            catch (e) {
                alert("There was a problem getting simulation results");
                log(e.message);
            }
        }
        else {
            //alert("No data for plot, check simulation results for error messages");
        }
    }
}

/***************************************************************
 * Function: checkLogOK
 * Params: n/a
 * DESC: check if plotting in log scale is ok
 ***************************************************************/
function checkLogOK() {
    // make sure to do this after the db is applied
    logXCapable = true;
    logYCapable = true;

    for (var xInd = 0; xInd < viData.length; xInd++) {
        for (var xInd2 = 0; xInd2 < viData[xInd].length; xInd2++) {
            if(xInd2 == 0 && viData[xInd][xInd2] < 0.0) { // x-axis is not in labelsToRemove2 so don't check for that here
                logXCapable = false;
            }
            // need labelsToRemove2[xInd2-1] since labelsToRemove2 does not include x-axis
            else if((xInd2 > 0) && (labelsToRemove2[xInd2-1] == true) && (viData[xInd][xInd2] <= 0.0)) {
                logYCapable = false;
            }
        }
    }
}


/***************************************************************
 * Function: doPlotUpdateAdv
 * Params: linesOn, ptsOn
 * DESC: custom plotting options helper functions
 ***************************************************************/
function doPlotUpdateAdv() {
    // plot 1 (skip x axis name)
    for (i = 1; i < labelNames.length; i++) {
        for (j = 0; j < labelsToRemove.length; j++) {
            if (labelsToRemove[j] == labelNames[i]) {
                // set series i to invisible
                dg1[0].setVisibility((i - 1), labelsToRemove2[j]);
            }
        }
    }

    checkLogOK();
    resizePlots();

    // reverse it, then click button so we can go through checks
    logYOn = !logYOn;
    doLogY($("#logYBtn")[0]);
};

function labelHelper(ind, checkbox) {
    labelsToRemove2[ind] = checkbox.checked;
}

// helper fnuction
function currentsOff() {
    // turn off currents
    for (cInd = 0; cInd < labelsToRemove.length; cInd++) {
        if (labelsToRemove[cInd].indexOf("I(") == 0) {
            labelsToRemove2[cInd] = false;
        }
    }
}

// return number of signals on, stop when > 10
function countNumSignalsPlotted(limitOn) {
    var cnt = 0;
    for (cInd = 0; cInd < labelsToRemove2.length; cInd++) {
        if (labelsToRemove2[cInd] == true) {
            cnt += 1;

            if (cnt > 10 && limitOn) {
                labelsToRemove2[cInd] = false; // hide this signal
            }
        }
    }
    return cnt;
}

// limit the number of signals plotted to 10
function limitNumSignalsPlotted() {
    countNumSignalsPlotted(true);
}

// make sure plot is appropriately sized
var lastNumSignals = 0;
var p1i_h = 0;
var p1i_w = 0;
function resizePlots() {
    $("#plotWrapper").css("width", "99%");
    p1i_h = ($('#plotWrapper').height() - 80);
    p1i_w = (($('#plotWrapper').width() * 7 / 10));
    return true;
}

/***************************************************************
 * Function: advancedPlotting
 * Params: n/a
 * DESC: custom plotting options helper functions
 ***************************************************************/
function advancedPlotting() {
    if (thedata.length > 0) {
        var newHt = '<b>Select signals to plot</b><br><br>' +
            '<table cellpadding="2" cellspacing="2" width="100%" id="plotSelectTable">';
        for (i = 0; i < labelsToRemove.length; i++) {
            newHt += '<tr style="background-color: #EEE">' +
                '<td align="center" valign="bottom" width="5%">' +
                '    <input type="checkbox" id="onOffCheckboxes' + (i) + 'a" name="onOffCheckboxes' + (i) + 'a" ' + (labelsToRemove2[i] ? 'checked="checked"' : '') + ' onchange=\'javascript: labelHelper(' + i + ', this); \' />' +
                '</td>' +
                '<td align="left" valign="top">' + labelsToRemove[i] + '</td>';
            newHt += '</tr>';
        }
        newHt += '<tr><td colspan="2" align="center"><br>' +
            '<input class="simBtn" type="button" value="Select All" onclick="javascript: { setAllCheckboxes(true); } "/>&nbsp;' +
            '<input class="simBtn" type="button" value="Clear All" onclick="javascript: { setAllCheckboxes(false); } "/>&nbsp;' +
            '<input class="simBtn" type="button" value="Apply Changes" onclick="javascript: { $(\'#plot1Cover\').hide(); doPlotUpdateAdv(); advancedPlotting(); $(\'#plotleg\').show(); $(\'#plotOptionsDiv\').hide(); $(\'#plotButtons\').show(); }"/>' +
            '</td></tr>'
        newHt += '</table><br><br><br><br>';

        $('#plotOptionsDiv').html(newHt);
    }
    else {
        alert('There is no data to modify');
    }
}

function setAllCheckboxes(val)
{
    var ind = 0;
    $('input:checkbox').each(function(){
        $(this).prop('checked',val);
        labelHelper(ind++, this);
    });
}

function doDB(btn)
{
    // save log states
    var saveLogXOn = logXOn;
    var saveLogYOn = logYOn;

    var saveLabelsToRemove = labelsToRemove.slice();
    var saveLabelsToRemove2 = labelsToRemove2.slice();

    if(dbOn) {
        dbOn = false;
        btn.value = "dB ON";
    } else {
        dbOn = true;
        btn.value = "dB OFF";
    }

    plot();

    // put back to how it was
    if(saveLogXOn != logXOn) {
        $("#logXBtn").click();
    }
    if(saveLogYOn != logYOn) {
        $("#logYBtn").click();
    }

    labelsToRemove = saveLabelsToRemove.slice();
    labelsToRemove2 = saveLabelsToRemove2.slice();
    doPlotUpdateAdv();
    advancedPlotting();
}

/**
 * HSV to RGB color conversion
 *
 * H runs from 0 to 360 degrees
 * S and V run from 0 to 100
 *
 * Ported from the excellent java algorithm by Eugene Vishnevsky at:
 * http://www.cs.rit.edu/~ncs/color/t_convert.html
 */
function hsvToRgb(h, s, v) {
    var r, g, b;
    var i;
    var f, p, q, t;

    // Make sure our arguments stay in-range
    h = Math.max(0, Math.min(360, h));
    s = Math.max(0, Math.min(100, s));
    v = Math.max(0, Math.min(100, v));

    // We accept saturation and value arguments from 0 to 100 because that's
    // how Photoshop represents those values. Internally, however, the
    // saturation and value are calculated from a range of 0 to 1. We make
    // That conversion here.
    s /= 100;
    v /= 100;

    if (s == 0) {
        // Achromatic (grey)
        r = g = b = v;
        return [Math.round(r * 255), Math.round(g * 255), Math.round(b * 255)];
    }

    h /= 60; // sector 0 to 5
    i = Math.floor(h);
    f = h - i; // factorial part of h
    p = v * (1 - s);
    q = v * (1 - s * f);
    t = v * (1 - s * (1 - f));

    switch (i) {
        case 0:
            r = v;
            g = t;
            b = p;
            break;

        case 1:
            r = q;
            g = v;
            b = p;
            break;

        case 2:
            r = p;
            g = v;
            b = t;
            break;

        case 3:
            r = p;
            g = q;
            b = v;
            break;

        case 4:
            r = t;
            g = p;
            b = v;
            break;

        default: // case 5:
            r = v;
            g = p;
            b = q;
    }

    return [Math.round(r * 255), Math.round(g * 255), Math.round(b * 255)];
}

// helper to make colors for plot
function colorScheme(total) {
    var i = 360 / (total - 1); // distribute the colors evenly on the hue range
    var r = []; // hold the generated colors
    for (var x = 0; x < total; x++) {
        var rgb = hsvToRgb(i * x, 75, 75);
        r.push("rgb(" + rgb[0] + "," + rgb[1] + "," + rgb[2] + ")"); // you can also alternate the saturation and value for even more contrast between the colors
        rgb = null;
    }
    return r;
}

function legendFormatter(data) {
    if (data.x == null) {
        // This happens when there's no selection and {legend: 'always'} is set.
        return '<br>' + data.series.map(function(series) { return series.dashHTML + ' ' + series.labelHTML }).join('<br>');
    }

    var html = this.getLabels()[0] + ': ' + data.xHTML;
    data.series.forEach(function(series) {
        if (!series.isVisible) return;
        var labeledData = series.labelHTML + ': ' + series.yHTML;
        if (series.isHighlighted) {
            labeledData = '<b>' + labeledData + '</b>';
        }
        html += '<br>' + series.dashHTML + ' ' + labeledData;
    });
    return html;
}
